/*
 * Decompiled with CFR 0.152.
 */
package com.digitalalbum.digitalalbum.service;

import com.digitalalbum.digitalalbum.dao.UserDao;
import com.digitalalbum.digitalalbum.model.Role;
import com.digitalalbum.digitalalbum.model.User;
import com.digitalalbum.digitalalbum.repository.UserRepository;
import com.digitalalbum.digitalalbum.request.PasswordChangeRequest;
import com.digitalalbum.digitalalbum.request.UserRequest;
import com.digitalalbum.digitalalbum.response.AuthenticationResponse;
import com.digitalalbum.digitalalbum.response.UserResponse;
import com.digitalalbum.digitalalbum.security.JwtService;
import com.digitalalbum.digitalalbum.service.AuthenticationService;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    private final UserRepository userRepository;
    private final JwtService jwtService;
    @Autowired
    private PasswordEncoder encoder;
    private final AuthenticationManager authenticationManager;
    @Autowired
    UserDao userDao;

    public AuthenticationResponse register(UserRequest request) {
        User user = User.builder().name(request.getName()).email(request.getEmail()).password(this.encoder.encode((CharSequence)request.getPassword())).role(Role.USER).mobile(request.getMobile()).build();
        this.userRepository.save((Object)user);
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(jwtToken).build();
    }

    public AuthenticationResponse authenticate(UserRequest request) {
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getEmail(), (Object)request.getPassword()));
        User user = (User)this.userRepository.findByEmail(request.getEmail()).orElseThrow(() -> new UsernameNotFoundException("user not found"));
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(jwtToken).build();
    }

    public UserResponse getDetails(String aS) {
        String bearer = aS.substring(aS.indexOf(".") + 1);
        String bearer1 = (String)bearer.subSequence(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearer1));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        if (creator.isPresent()) {
            UserResponse res = new UserResponse();
            User user = (User)creator.get();
            res.setEmail(user.getEmail());
            res.setName(user.getName());
            res.setId(user.getId());
            res.setMobile(user.getMobile());
            res.setRole(user.getRole());
            return res;
        }
        throw new RuntimeException("Error: User not found.");
    }

    public PasswordChangeRequest getPassDetails(String as) {
        String bearer = as.substring(as.lastIndexOf(".") + 1);
        String bearers = bearer.substring(0, bearer.lastIndexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearers));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEmail(userName);
        if (creator.isPresent()) {
            PasswordChangeRequest res = new PasswordChangeRequest();
            User user = (User)creator.get();
            res.setOldPassword(user.getPassword());
            return res;
        }
        throw new RuntimeException("Error:User not found");
    }

    public void pass() {
        System.out.println("password" + this.encoder.encode((CharSequence)"2020"));
    }

    public ResponseEntity<?> checkEmail(String email) {
        try {
            Optional user = this.userDao.findByEamil(email);
            if (user.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Email id is already present");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)"Email is available");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while check email" + e.getMessage());
        }
    }

    public ResponseEntity<?> checkMobile(Long mobile) {
        try {
            Optional optional = this.userDao.findByMobile(mobile);
            if (optional.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Mobile number is already present");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)"Mobile number is available");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while check mobile" + e.getMessage());
        }
    }

    @Generated
    public AuthenticationServiceImpl(UserRepository userRepository, JwtService jwtService, AuthenticationManager authenticationManager) {
        this.userRepository = userRepository;
        this.jwtService = jwtService;
        this.authenticationManager = authenticationManager;
    }
}

