/*
 * Decompiled with CFR 0.152.
 */
package com.digitalalbum.digitalalbum.service;

import com.digitalalbum.digitalalbum.dao.UserDao;
import com.digitalalbum.digitalalbum.model.User;
import com.digitalalbum.digitalalbum.request.PasswordChangeRequest;
import com.digitalalbum.digitalalbum.request.UserDto;
import com.digitalalbum.digitalalbum.response.ResponseDto;
import com.digitalalbum.digitalalbum.service.AuthenticationService;
import com.digitalalbum.digitalalbum.service.OTPService;
import com.digitalalbum.digitalalbum.service.PasswordChangeService;
import com.digitalalbum.digitalalbum.util.JavaSendApi;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PasswordChangeServiceImpl
implements PasswordChangeService {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private PasswordEncoder encoder;
    @Autowired
    UserDao userDao;
    @Autowired
    JavaSendApi javaSendApi;

    public ResponseEntity<?> changePassword(PasswordChangeRequest changeRequest, String token) {
        try {
            PasswordChangeRequest password = this.authenticationService.getPassDetails(token);
            if (!this.encoder.matches((CharSequence)changeRequest.getOldPassword(), password.getOldPassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Old password is incorrecct");
            }
            if (!changeRequest.getNewPassword().equals(changeRequest.getReenterPassword())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"New Password and re-enter password do not match");
            }
            Optional users = this.userDao.findById(changeRequest.getId());
            if (users.isEmpty()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"User not found");
            }
            User user = (User)users.get();
            String newPassword = changeRequest.getNewPassword();
            user.setPassword(this.encoder.encode((CharSequence)newPassword));
            this.userDao.save(user);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Password changed successfully");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while changing the password: " + e.getMessage()));
        }
    }

    public ResponseDto forgetPassword(UserDto request) {
        try {
            System.out.println("request.getEmail(): " + request.getEmail());
            if (request.getEmail() == null && request.getRole() == null) {
                return new ResponseDto("Error", "Email is required.", "Test");
            }
            Optional user = this.userDao.findByEmail(request.getEmail());
            if (!user.isPresent()) {
                return new ResponseDto("Error", "User not found with the provided email.", "Test");
            }
            if (request.getOtp() == null) {
                return new ResponseDto("Error", "OTP is required.", "Test");
            }
            if (request.getPassword() == null) {
                return new ResponseDto("Error", "New password is required.", "Test");
            }
            boolean isVerified = OTPService.verifyOTP((String)request.getEmail(), (String)request.getOtp());
            if (!isVerified) {
                return new ResponseDto("Error", "Invalid OTP.", "Test");
            }
            ((User)user.get()).setPassword(this.encoder.encode((CharSequence)request.getPassword()));
            this.userDao.save((User)user.get());
            return new ResponseDto("Success", "Password changed successfully.", "Test");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseDto("Error", "An unexpected error occurred. Please try again later.", "Test");
        }
    }

    public ResponseDto sendOtpForAccountCreation(UserDto request) {
        try {
            System.out.println("Generate OTP for Account Creation");
            String otp = OTPService.generateOTP();
            System.out.println("generate Otp" + otp);
            OTPService.storeOTPInDatabase((String)request.getEmail(), (String)otp);
            System.out.println("OTP store in the database");
            String body = "<html><p>Welcome to digital album! To complete your account setup, please use the OTP below:</p><p><strong>Your OTP: " + otp + "</strong></p><p>This OTP is valid for the next 10 minutes. Please enter it on the registration page to verify your email address.</p><p>If you did not request an account with digital album, please ignore this email.</p><br><p>Best regards,</p><p>The digital album Team</p><p><a href='mailto:support@digitalalbum.com'>support@digitalalbum.com</a></p><p><a href='https://digitalalbum.com'>vcard.com</a></p></html>";
            String subject = "Digital Album Account Verification OTP";
            this.javaSendApi.sendMailWithAttachment(request.getEmail(), body, subject);
            return new ResponseDto("Success", "OTP has been sent to your email for account creation.", "Info");
        }
        catch (Exception e) {
            return new ResponseDto("Error", "Something went wrong while sending the OTP.", "Error");
        }
    }

    public String otpverification(UserDto userDto) {
        try {
            boolean verifyOTP = OTPService.verifyOTP((String)userDto.getEmail(), (String)userDto.getOtp());
            if (verifyOTP) {
                return "Success OTP verified successfully. Account creation can proceed.Info";
            }
            return "Error Invalid OTP. Please check and try again.Info";
        }
        catch (Exception e) {
            return "ErrorAn error occurred while verifying the OTP.Error";
        }
    }
}

