/*
 * Decompiled with CFR 0.152.
 */
package com.digitalalbum.digitalalbum.service;

import com.digitalalbum.digitalalbum.model.AlbumSize;
import com.digitalalbum.digitalalbum.model.FileModel;
import com.digitalalbum.digitalalbum.repository.AlbumRepository;
import com.digitalalbum.digitalalbum.repository.FileModelRepository;
import com.digitalalbum.digitalalbum.response.ResponseAlbumDto;
import com.digitalalbum.digitalalbum.response.ResponseGalleryDTO;
import com.digitalalbum.digitalalbum.service.FileService;
import com.digitalalbum.digitalalbum.service.UserPhotoService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserPhotoService {
    @Autowired
    private FileService fileService;
    @Autowired
    private FileModelRepository fileModelRepository;
    @Autowired
    private AlbumRepository albumRepository;

    public FileModel addprofile(MultipartFile file) {
        try {
            if (file.isEmpty()) {
                throw new IllegalArgumentException("file cannot be empty");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                throw new IllegalArgumentException("Invalid file type");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String directoryPath = "/photostudio";
            String remotePath = directoryPath + "/" + fileName;
            boolean directoryCreated = this.fileService.createDirectory(directoryPath);
            if (!directoryCreated) {
                throw new RuntimeException("Failed to create directory: " + directoryPath);
            }
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.roll36.com" + remotePath;
            ResponseAlbumDto albumDto = new ResponseAlbumDto(uploadedUrl);
            FileModel model = new FileModel();
            model.setUrlpath(uploadedUrl);
            FileModel fileModel = (FileModel)this.fileModelRepository.save((Object)model);
            return fileModel;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error occurred while processing the file: " + e.getMessage());
        }
    }

    public ResponseEntity<?> add(MultipartFile file, AlbumSize size) {
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            int width = 0;
            int height = 0;
            switch (1.$SwitchMap$com$digitalalbum$digitalalbum$model$AlbumSize[size.ordinal()]) {
                case 1: {
                    width = 13;
                    height = 12;
                    break;
                }
                case 2: {
                    width = 24;
                    height = 15;
                    break;
                }
                case 3: {
                    width = 24;
                    height = 18;
                    break;
                }
                case 4: {
                    width = 24;
                    height = 16;
                    break;
                }
                case 5: {
                    width = 12;
                    height = 12;
                    break;
                }
                case 6: {
                    width = 30;
                    height = 15;
                    break;
                }
                default: {
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid size.");
                }
            }
            ByteArrayOutputStream compressedOutputStream = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{file.getInputStream()}).size(width * 100, height * 100).outputQuality(0.8).toOutputStream((OutputStream)compressedOutputStream);
            byte[] compressedData = compressedOutputStream.toByteArray();
            while (compressedData.length > 0xA00000) {
                compressedOutputStream.reset();
                Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(compressedData)}).scale(0.9).outputQuality(0.7).toOutputStream((OutputStream)compressedOutputStream);
                compressedData = compressedOutputStream.toByteArray();
            }
            ByteArrayInputStream compressedInputStream = new ByteArrayInputStream(compressedData);
            String directoryPath = "/naveen";
            String remotePath = directoryPath + "/" + fileName;
            boolean directoryCreated = this.fileService.createDirectory(directoryPath);
            if (!directoryCreated) {
                throw new RuntimeException("Failed to create directory: " + directoryPath);
            }
            this.fileService.upload(remotePath, (InputStream)compressedInputStream);
            String uploadedUrl = "https://storage.roll36.com" + remotePath;
            FileModel fileModel = new FileModel();
            fileModel.setUrlpath(uploadedUrl);
            fileModel = (FileModel)this.fileModelRepository.save((Object)fileModel);
            ResponseGalleryDTO response = new ResponseGalleryDTO(fileModel.getId(), uploadedUrl);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }

    public FileModel addProfile(MultipartFile file) {
        FTPClient ftpClient = new FTPClient();
        try {
            FileModel fileModel;
            if (file.isEmpty()) {
                throw new IllegalArgumentException("File cannot be empty");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                throw new IllegalArgumentException("Invalid file type");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String server = "your-ftp-server.com";
            int port = 21;
            String user = "your-ftp-username";
            String password = "your-ftp-password";
            ftpClient.connect(server, port);
            ftpClient.login(user, password);
            String directory = "/digitalalbum";
            if (!ftpClient.changeWorkingDirectory(directory)) {
                if (ftpClient.makeDirectory(directory)) {
                    System.out.println("Directory created: " + directory);
                } else {
                    throw new RuntimeException("Failed to create directory: " + directory);
                }
            }
            String remotePath = directory + "/" + fileName;
            ftpClient.setFileType(2);
            ftpClient.storeFile(remotePath, file.getInputStream());
            String uploadedUrl = "https://storage.roll36.com" + remotePath;
            FileModel model = new FileModel();
            model.setUrlpath(uploadedUrl);
            FileModel fileModel2 = fileModel = (FileModel)this.fileModelRepository.save((Object)model);
            return fileModel2;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error occurred while processing the file: " + e.getMessage());
        }
        finally {
            try {
                if (ftpClient.isConnected()) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

