/*
 * Decompiled with CFR 0.152.
 */
package com.digitalalbum.digitalalbum.controller;

import com.digitalalbum.digitalalbum.model.AlbumModel;
import com.digitalalbum.digitalalbum.model.AlbumSize;
import com.digitalalbum.digitalalbum.request.AlbumRequest;
import com.digitalalbum.digitalalbum.service.AlbumService;
import com.digitalalbum.digitalalbum.service.UserPhotoService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/album"})
public class AlbumController {
    @Autowired
    private AlbumService albumService;
    @Autowired
    private UserPhotoService photoService;

    @PostMapping(value={"/upload"})
    public ResponseEntity<AlbumModel> uploadPhoto(@RequestBody AlbumRequest request, @RequestHeader(value="Authorization") String as) {
        try {
            AlbumModel albumModel = this.albumService.uploadPhoto(request, as);
            return ResponseEntity.ok((Object)albumModel);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<List<AlbumRequest>> getAllPhoto(@RequestHeader(value="Authorization") String AS) {
        try {
            List models = this.albumService.getAllPhoto(AS);
            return ResponseEntity.ok((Object)models);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<String> deletePhoto(@RequestParam Long albumId) {
        try {
            String albumModel = this.albumService.deletePhoto(albumId);
            return ResponseEntity.ok((Object)albumModel);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/addprofile"})
    public ResponseEntity<?> addprofile(@RequestParam(value="file") MultipartFile file) {
        try {
            return this.photoService.add(file);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while add profile");
        }
    }

    @GetMapping(value={"/findbyid"})
    public ResponseEntity<?> findByAlbumId(@RequestParam Long id, @RequestHeader(value="Authorization") String AS) {
        try {
            AlbumRequest albumModel = this.albumService.findByAlbumId(id, AS);
            return ResponseEntity.ok((Object)albumModel);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/albumsize"})
    public ResponseEntity<List<AlbumSize>> getAllAlbumSize() {
        try {
            List<AlbumSize> types = Arrays.asList(AlbumSize.values());
            return ResponseEntity.ok(types);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonList((AlbumSize)AlbumSize.valueOf(null, null)));
        }
    }
}

