/*
 * Decompiled with CFR 0.152.
 */
package com.digitalalbum.digitalalbum.controller;

import com.digitalalbum.digitalalbum.request.PasswordChangeRequest;
import com.digitalalbum.digitalalbum.request.UserDto;
import com.digitalalbum.digitalalbum.service.AuthenticationService;
import com.digitalalbum.digitalalbum.service.PasswordChangeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthenticationController {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private PasswordChangeService changeService;

    @PostMapping(value={"/changepassword"})
    public ResponseEntity<?> changePassword(@RequestBody PasswordChangeRequest changeRequest, @RequestHeader(value="Authorization") String token) {
        try {
            return this.changeService.changePassword(changeRequest, token);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while changing password" + e.getMessage()));
        }
    }

    @PutMapping(value={"/forgetpassword"})
    public ResponseEntity<?> forgetPassword(@RequestBody UserDto request) throws Exception {
        return ResponseEntity.ok((Object)this.changeService.forgetPassword(request));
    }

    @PutMapping(value={"/sendotp"})
    public ResponseEntity<?> sendotp(@RequestBody UserDto request) throws Exception {
        return ResponseEntity.ok((Object)this.changeService.sendOtpForAccountCreation(request));
    }

    @PutMapping(value={"otpverification"})
    public ResponseEntity<?> otpverification(@RequestBody UserDto userDto) {
        try {
            String string = this.changeService.otpverification(userDto);
            return ResponseEntity.ok((Object)string);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error creating otp verification" + e.getMessage()));
        }
    }

    @PutMapping(value={"/checkemail"})
    public ResponseEntity<?> checkEmail(@RequestParam String email) {
        try {
            return this.authenticationService.checkEmail(email);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while check email" + e.getMessage()));
        }
    }

    @PutMapping(value={"/checkmobile"})
    public ResponseEntity<?> checkMobile(@RequestParam Long mobile) {
        try {
            return this.authenticationService.checkMobile(mobile);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while check mobile" + e.getMessage()));
        }
    }
}

