/*
 * Decompiled with CFR 0.152.
 */
package com.digitalalbum.digitalalbum.service;

import com.digitalalbum.digitalalbum.dao.AlbumDao;
import com.digitalalbum.digitalalbum.model.AlbumModel;
import com.digitalalbum.digitalalbum.model.FileModel;
import com.digitalalbum.digitalalbum.repository.FileModelRepository;
import com.digitalalbum.digitalalbum.repository.UserRepository;
import com.digitalalbum.digitalalbum.request.AlbumRequest;
import com.digitalalbum.digitalalbum.response.ResponseGalleryDTO;
import com.digitalalbum.digitalalbum.response.UserResponse;
import com.digitalalbum.digitalalbum.service.AlbumService;
import com.digitalalbum.digitalalbum.service.AuthenticationService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlbumServiceImpl
implements AlbumService {
    @Autowired
    private AlbumDao albumDao;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private FileModelRepository fileModelRepository;
    @Autowired
    private AuthenticationService authenticationService;

    public AlbumModel uploadPhoto(AlbumRequest request, String as) {
        try {
            AlbumModel model = new AlbumModel();
            model.setAlbumName(request.getAlbumName());
            model.setFirstPage(request.getFirstPage());
            model.setLastPage(request.getLastPage());
            model.setNoOfPage(request.getNoOfPage());
            model.setPlan(request.getPlan());
            model.setDescription(request.getDescription());
            model.setCreatedDateTime(request.getCreatedDateTime());
            model.setSize(request.getSize());
            UserResponse response = this.authenticationService.getDetails(as);
            if (response == null || response.getId() == null) {
                throw new IllegalArgumentException("User id is not found");
            }
            model.setUserId(request.getUserId());
            AlbumModel albumModel = this.albumDao.uploadPhoto(model);
            Long saveAlbumId = albumModel.getAlbumId();
            if (request.getFileIds() != null && !request.getFileIds().isEmpty()) {
                for (Long fileId : request.getFileIds()) {
                    FileModel fileModel = (FileModel)this.fileModelRepository.findById((Object)fileId).get();
                    fileModel.setAlbumid(saveAlbumId);
                    this.fileModelRepository.save((Object)fileModel);
                }
            }
            ArrayList associatedFileIds = new ArrayList(request.getFileIds());
            albumModel.setFileIds(associatedFileIds);
            return this.albumDao.save(albumModel);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while upload photo" + e.getMessage());
        }
    }

    public String deletePhoto(Long albumId) {
        try {
            this.albumDao.deletePhoto(albumId);
            return "Photo delete successfully!!!";
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while delete photo" + e.getMessage());
        }
    }

    public AlbumRequest findByAlbumId(Long id, String as) {
        try {
            AlbumModel albumModel = (AlbumModel)this.albumDao.findByAlbumId(id).orElseThrow(() -> new RuntimeException("Album not found with ID: " + id));
            AlbumRequest albumRequest = new AlbumRequest();
            albumRequest.setAlbumId(albumModel.getAlbumId());
            albumRequest.setAlbumName(albumModel.getAlbumName());
            albumRequest.setPlan(albumModel.getPlan());
            albumRequest.setFirstPage(albumModel.getFirstPage());
            albumRequest.setLastPage(albumModel.getLastPage());
            albumRequest.setNoOfPage(albumModel.getNoOfPage());
            albumRequest.setDescription(albumModel.getDescription());
            albumRequest.setCreatedDateTime(albumModel.getCreatedDateTime());
            albumRequest.setSize(albumModel.getSize());
            UserResponse response = this.authenticationService.getDetails(as);
            if (response == null || response.getId() == null) {
                throw new IllegalArgumentException("User id is not found");
            }
            albumRequest.setUserId(albumModel.getUserId());
            ArrayList<ResponseGalleryDTO> responseGalleryDTOs = new ArrayList<ResponseGalleryDTO>();
            if (albumModel.getFileIds() != null && !albumModel.getFileIds().isEmpty()) {
                for (Long fileId : albumModel.getFileIds()) {
                    try {
                        FileModel fileModel = (FileModel)this.fileModelRepository.findById((Object)fileId).orElseThrow(() -> new RuntimeException("File not found with ID: " + fileId));
                        responseGalleryDTOs.add(new ResponseGalleryDTO(fileId, fileModel.getUrlpath()));
                    }
                    catch (Exception ex) {
                        System.err.println("Error retrieving file with ID: " + fileId + ". " + ex.getMessage());
                    }
                }
            }
            albumRequest.setList(responseGalleryDTOs);
            return albumRequest;
        }
        catch (RuntimeException e) {
            System.err.println("Error occurred in findByAlbumId: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            System.err.println("Unexpected error in findByAlbumId: " + e.getMessage());
            throw new RuntimeException("Unexpected error occurred while finding album by ID: " + id, e);
        }
    }

    public List<AlbumRequest> getAllPhoto(String as) {
        try {
            List albumModels = this.albumDao.findAll();
            ArrayList<AlbumRequest> albumRequests = new ArrayList<AlbumRequest>();
            for (AlbumModel albumModel : albumModels) {
                AlbumRequest albumRequest = new AlbumRequest();
                albumRequest.setAlbumId(albumModel.getAlbumId());
                albumRequest.setAlbumName(albumModel.getAlbumName());
                albumRequest.setPlan(albumModel.getPlan());
                albumRequest.setFirstPage(albumModel.getFirstPage());
                albumRequest.setLastPage(albumModel.getLastPage());
                albumRequest.setNoOfPage(albumModel.getNoOfPage());
                albumRequest.setDescription(albumModel.getDescription());
                albumRequest.setCreatedDateTime(albumModel.getCreatedDateTime());
                albumRequest.setSize(albumModel.getSize());
                UserResponse response = this.authenticationService.getDetails(as);
                if (response == null || response.getId() == null) {
                    throw new IllegalArgumentException("User id is not found");
                }
                albumRequest.setUserId(albumModel.getUserId());
                ArrayList<ResponseGalleryDTO> responseGalleryDTOs = new ArrayList<ResponseGalleryDTO>();
                if (albumModel.getFileIds() != null && !albumModel.getFileIds().isEmpty()) {
                    for (Long fileId : albumModel.getFileIds()) {
                        try {
                            FileModel fileModel = (FileModel)this.fileModelRepository.findById((Object)fileId).orElseThrow(() -> new RuntimeException("File not found with ID: " + fileId));
                            responseGalleryDTOs.add(new ResponseGalleryDTO(fileId, fileModel.getUrlpath()));
                        }
                        catch (Exception ex) {
                            System.err.println("Error retrieving file with ID: " + fileId + ". " + ex.getMessage());
                        }
                    }
                }
                albumRequest.setList(responseGalleryDTOs);
                albumRequests.add(albumRequest);
            }
            return albumRequests;
        }
        catch (Exception e) {
            System.err.println("Unexpected error in getAllPhoto: " + e.getMessage());
            throw new RuntimeException("Unexpected error occurred while fetching all albums", e);
        }
    }
}

