/*
 * Decompiled with CFR 0.152.
 */
package com.digitalalbum.digitalalbum.service;

import com.digitalalbum.digitalalbum.model.FileModel;
import com.digitalalbum.digitalalbum.repository.AlbumRepository;
import com.digitalalbum.digitalalbum.repository.FileModelRepository;
import com.digitalalbum.digitalalbum.response.ResponseAlbumDto;
import com.digitalalbum.digitalalbum.response.ResponseGalleryDTO;
import com.digitalalbum.digitalalbum.service.FileService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserPhotoService {
    @Autowired
    private FileService fileService;
    @Autowired
    private FileModelRepository fileModelRepository;
    @Autowired
    private AlbumRepository albumRepository;

    public FileModel addprofile(MultipartFile file) {
        try {
            if (file.isEmpty()) {
                throw new IllegalArgumentException("file cannot be empty");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                throw new IllegalArgumentException("Invalid file type");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/digitalalbum/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            ResponseAlbumDto albumDto = new ResponseAlbumDto(uploadedUrl);
            FileModel model = new FileModel();
            model.setUrlpath(uploadedUrl);
            FileModel fileModel = (FileModel)this.fileModelRepository.save((Object)model);
            return fileModel;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error occurred while processing the file: " + e.getMessage());
        }
    }

    public ResponseEntity<?> add(MultipartFile file) {
        try {
            System.out.println("");
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/digitalalbum/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.megashop.my" + remotePath;
            FileModel fileModel = new FileModel();
            fileModel.setUrlpath(uploadedUrl);
            fileModel = (FileModel)this.fileModelRepository.save((Object)fileModel);
            ResponseGalleryDTO response = new ResponseGalleryDTO(fileModel.getId(), uploadedUrl);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }
}

